<?php
$cssVariables = collect(config('themes.light'))
    ->mapWithKeys(fn($value, $key) => [$key => $value])
    ->map(fn($value, $key) => "$key: $value;")
    ->implode(''); ?>

        <!DOCTYPE html>
<html style="<?php echo e($cssVariables); ?>">
<head>
    <title>Custom domain connected</title>
    <link href="<?php echo e(getMainCssFileUrl()); ?>" rel="stylesheet">
</head>
<body class="bg-alt flex flex-col items-center justify-center text-main">
<img src="<?php echo e(file_exists(public_path('images/logo-dark.png')) ? asset('images/logo-dark.png') : asset('images/logo-dark.svg')); ?>"
     alt="Logo" class="h-40 mb-34"/>
<div class="w-680 max-w-full p-24 rounded-md bg shadow border text-center">
    <?php echo e($content); ?>

</div>
</body>
</html>

<?php /**PATH /home/oqxtcdhnum/drive.kathok.net/common/foundation/resources/views/domains/domain-connected-message.blade.php ENDPATH**/ ?>