<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo e(__('Invoice')); ?></title>
    <base href="<?php echo e($htmlBaseUri); ?>">
    <link rel="stylesheet" href="invoice.css">
    <style>
        h1 {
            display: inline-block;
        }

        h2 { font-size: 2em; }

        .invoice-details {
            float: right;
        }

        .invoice-details span { font-weight: normal; font-size: .9em;}

        .total { float: right; }
        .total .amount { font-weight: normal; }

        table { margin-top: 50px; border-radius: 4px; overflow: hidden }
        thead { background: #4662fa; color: white; }
        thead th { border: none !important; }

        .notice {
            background: #d7d7d7;
            padding: 2em;
            clear: both;
            margin-top: 6em;
            border-radius: 4px;
        }

        .col {
            float: left;
            width: 300px;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="row">
        <h1><?php echo e(parse_url(config('app.url'))['host']); ?></h1>
        <div class="invoice-details">
            <h2 contenteditable><?php echo e(__('Invoice ID')); ?>: <?php echo e($invoice['uuid']); ?></h2>
            <h4 contenteditable><?php echo e(__('Invoice Date')); ?>: <span id="date-of-invoice"><?php echo e($invoice['created_at']); ?></span></h4>
        </div>
    </div>
    <div class="row billing__references">
        <div class="col">
            <h4><?php echo e(__('Billed To')); ?>:</h4>
            <h5 contenteditable><?php echo e($user['name']); ?></h5>
            <p contenteditable><?php echo e($user['email']); ?></p>
        </div>
        <div class="col">
            <h4><?php echo e(__('From')); ?>:</h4>
            <h5><?php echo e(config('app.name')); ?></h5>
            <?php if($address = $settings->get('billing.invoice.address')): ?>
                <p class="address" contenteditable>
                    <?php echo $address; ?>

                </p>
            <?php endif; ?>
        </div>
    </div>
    <div class="row billing__lines">
        <table class="lines table table-striped">
            <thead>
            <tr>
                <th><?php echo e(__('Description')); ?></th>
                <th><?php echo e(__('Qty')); ?></th>
                <th><?php echo e(__('Price')); ?></th>
            </tr>
            </thead>
            <tbody>
            <tr contenteditable>
                <td><?php echo e(config('app.name')); ?> <?php echo e(__('Subscription Dues')); ?> (<?php echo e($invoice['subscription']['product']['name']); ?> <?php echo e(__('plan')); ?>)</td>
                <td>1</td>
                <td><?php echo e($invoice['currency_symbol']); ?><?php echo e($invoice['subscription']['price']['amount']); ?></td>
            </tr>
            </tbody>
        </table>
        <div class="total">
            <h4><?php echo e(__('Total')); ?>: <span class="amount"><?php echo e($invoice['subscription']['price']['currency_symbol']); ?><?php echo e($invoice['subscription']['price']['amount']); ?> <?php echo e($invoice['subscription']['price']['currency']); ?></span></h4>
        </div>
        <?php if($notes = $settings->get('billing.invoice.notes')): ?>
            <div class="notes notice" contenteditable>
                <h5><?php echo e(__('Notes')); ?></h5>
                <p><?php echo $notes; ?></p>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    window.print();
</script>
</body>
</html>
<?php /**PATH /home/oqxtcdhnum/drive.kathok.net/common/foundation/resources/views/billing/invoice.blade.php ENDPATH**/ ?>