import {useEffect, useRef, useState} from 'react';
import {FilePreviewProps} from './file-preview-props';
import {DefaultFilePreview} from './default-file-preview';
import {useFileEntryUrls} from '../../../file-entry-urls';

export function VideoFilePreview(props: FilePreviewProps) {
  const {entry, className} = props;
  const {previewUrl} = useFileEntryUrls(entry);
  const ref = useRef<HTMLVideoElement>(null);
  const [mediaInvalid, setMediaInvalid] = useState(false);

  useEffect(() => {
    // Check if browser can play this video format
    if (ref.current) {
      const canPlay = ref.current.canPlayType(entry.mime) || 
                     // For MOV files, browsers often support them even if they don't explicitly report it
                     entry.mime === 'video/quicktime' || entry.extension?.toLowerCase() === 'mov';
      setMediaInvalid(!canPlay);
    }
  }, [entry]);

  if (mediaInvalid || !previewUrl) {
    return <DefaultFilePreview {...props} />;
  }

  return (
    <video
      className={className}
      ref={ref}
      controls
      controlsList="nodownload noremoteplayback"
      playsInline
      autoPlay
    >
      <source
        src={previewUrl}
        type={entry.mime}
        onError={() => {
          setMediaInvalid(true);
        }}
      />
    </video>
  );
}