import {extensionFromFilename} from './extension-from-filename';

export function getFileMime(file: File): string {
  const extensionsToMime: Record<string, string> = {
    md: 'text/markdown',
    markdown: 'text/markdown',
    mp4: 'video/mp4',
    mov: 'video/quicktime',
    mp3: 'audio/mp3',
    svg: 'image/svg+xml',
    jpg: 'image/jpeg',
    jpeg: 'image/jpeg',
    png: 'image/png',
    gif: 'image/gif',
    heic: 'image/heic',
    heif: 'image/heif',
    // Add support for more image formats
    tiff: 'image/tiff',
    tif: 'image/tiff',
    webp: 'image/webp',
    bmp: 'image/bmp',
    ico: 'image/x-icon',
    avif: 'image/avif',
    yaml: 'text/yaml',
    yml: 'text/yaml',
    log: 'text/plain',
  };

  // Get file extension and convert to lowercase for case-insensitive comparison
  const fileExtension = file.name ? extensionFromFilename(file.name).toLowerCase() : null;

  // check if mime type is set in the file object
  if (file.type) {
    return file.type;
  }

  // see if we can map extension to a mime type
  if (fileExtension && fileExtension in extensionsToMime) {
    return extensionsToMime[fileExtension];
  }

  return 'application/octet-stream';
}